function [colcluster, colline]=get_graph_colours(colour)
%Function to generate a set of standard markers or lines
%Handy tool for plotting.
%USAGE
%[colcluster, colline]=Get_graph_colours(colour)
%
%INPUT
%   colour: 1/0 for black and white or colour markers and lines
%OUTPUT
%   colcluster: cells with different marker colours
%   colline: cells with different line types and colours
%
%Tom Schut, 2015

if colour
    %color codes
    colcluster{1} ={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{2} ={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{3} ={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{4} ={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{5} ={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{6} ={'d' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{7} ={'^' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{8} ={'s' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{9} ={'o' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{10}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{11}={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{12}={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{13}={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{14}={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{15}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{16}={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{17}={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{18}={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{19}={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{20}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};

    colcluster={'+b' 'or' 'dg' 'sy' '^m' 'xk' '*c'...
                     'ob' '*r' 'xg' '^y' 'sm' 'dk' 'oc'...
                     'sb' '+r' 'sg' '+y' 'xm' 'ok' 'xc'};
                 
   colline={'-k' '-b' '-r' '-g' '-y' '-m' '-c'...
                  ':k' ':b' ':r' ':g' ':y' ':m' ':c'...
                  '-.k' '-.b' '-.r' '-.g' '-.y' '-.m' '-.c'...
                  '--k' '-.b' '-.r' '--g' '--y' '--m' '--c'};
              
    colline{1}  ={'-'  'Color' [1.0 0.0 0.0]};%red
    colline{2}  ={':'  'Color' [1.0 0.0 0.0]};
    colline{3}  ={'-.' 'Color' [1.0 0.0 0.0]};
    colline{4}  ={'-'  'Color' [0.0 0.0 1.0]};%blue
    colline{5}  ={':'  'Color' [0.0 0.0 1.0]};
    colline{6}  ={'-.' 'Color' [0.0 0.0 1.0]};
    colline{7}  ={'-'  'Color' [0.0 1.0 0.0]};%green
    colline{8}  ={':'  'Color' [0.0 1.0 0.0]};
    colline{9}  ={'-.' 'Color' [0.0 1.0 0.0]};
    colline{10} ={'-'  'Color' [1.0 1.0 0.0]};%yellow
    colline{11} ={':'  'Color' [1.0 1.0 0.0]};
    colline{12} ={'-.' 'Color' [1.0 1.0 0.0]};
    colline{13} ={'-'  'Color' [1.0 0.0 1.0]};%cyan
    colline{14} ={':'  'Color' [1.0 0.0 1.0]};
    colline{15} ={'-.' 'Color' [1.0 0.0 1.0]};
    colline{16} ={'-'  'Color' [0.0 1.0 1.0]};%magenta
    colline{17} ={':'  'Color' [0.0 1.0 1.0]};
    colline{18} ={'-.' 'Color' [0.0 1.0 1.0]};
    colline{19} ={'-'  'Color' 0.5*[1.0 0.0 0.0]};%red
    colline{20} ={':'  'Color' 0.5*[1.0 0.0 0.0]};
    colline{21} ={'-.' 'Color' 0.5*[1.0 0.0 0.0]};
    colline{22} ={'-'  'Color' 0.5*[0.0 0.0 1.0]};%blue
    colline{23} ={':'  'Color' 0.5*[0.0 0.0 1.0]};
    colline{24} ={'-.' 'Color' 0.5*[0.0 0.0 1.0]};
    colline{25} ={'-'  'Color' 0.5*[0.0 1.0 0.0]};%green
    colline{26} ={':'  'Color' 0.5*[0.0 1.0 0.0]};
    colline{27} ={'-.' 'Color' 0.5*[0.0 1.0 0.0]};
    colline{28} ={'-'  'Color' 0.5*[1.0 1.0 0.0]};%yellow
    colline{29} ={':'  'Color' 0.5*[1.0 1.0 0.0]};
    colline{30} ={'-.' 'Color' 0.5*[1.0 1.0 0.0]};
    colline{31} ={'-'  'Color' 0.5*[1.0 0.0 1.0]};%cyan
    colline{32} ={':'  'Color' 0.5*[1.0 0.0 1.0]};
    colline{33} ={'-.' 'Color' 0.5*[1.0 0.0 1.0]};
    colline{34} ={'-'  'Color' 0.5*[0.0 1.0 1.0]};%magenta
    colline{35} ={':'  'Color' 0.5*[0.0 1.0 1.0]};
    colline{36} ={'-.' 'Color' 0.5*[0.0 1.0 1.0]};

else
    %black edges black, white, light grey and dark grey
    colcluster{1} ={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{2} ={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{3} ={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{4} ={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{5} ={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.0 0.0 0.0]};
    colcluster{6} ={'d' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{7} ={'^' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{8} ={'s' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{9} ={'o' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{10}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [1.0 1.0 1.0]};
    colcluster{11}={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{12}={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{13}={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{14}={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{15}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.8 0.8 0.8]};
    colcluster{16}={'d' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{17}={'^' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{18}={'s' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{19}={'o' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};
    colcluster{20}={'p' 'Color' [0 0 0] 'MarkerFaceColor' [0.3 0.3 0.3]};

    colline{1} ={'-' 'Color' [0.0 0.0 0.0]};
    colline{2} ={'-' 'Color' [0.8 0.8 0.8]};
    colline{3} ={'-' 'Color' [0.5 0.5 0.5]};
    colline{4} ={'-' 'Color' [0.3 0.3 0.3]};
    colline{5} ={':' 'Color' [0.0 0.0 0.0]};
    colline{6} ={':' 'Color' [0.8 0.8 0.8]};
    colline{7} ={':' 'Color' [0.5 0.5 0.5]};
    colline{8} ={':' 'Color' [0.3 0.3 0.3]};
    colline{9} ={'-.' 'Color' [0.0 0.0 0.0]};
    colline{10} ={'-.' 'Color' [0.8 0.8 0.8]};
    colline{11} ={'-.' 'Color' [0.5 0.5 0.5]};
    colline{12} ={'-.' 'Color' [0.3 0.3 0.3]};
    colline{13} ={'--' 'Color' [0.0 0.0 0.0]};
    colline{14} ={'--' 'Color' [0.8 0.8 0.8]};
    colline{15} ={'--' 'Color' [0.5 0.5 0.5]};
    colline{16} ={'--' 'Color' [0.3 0.3 0.3]};
    colline{17} ={'-'  'Color' [0.15 0.15 0.15]};
    colline{18} ={':'  'Color' [0.15 0.15 0.15]};
    colline{19} ={'-.' 'Color' [0.15 0.15 0.15]};
    colline{20} ={'--' 'Color' [0.15 0.15 0.15]};
end
